package com.agilex.healthcare.directscheduling.dao;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import org.springframework.stereotype.Repository;

import com.agilex.healthcare.directscheduling.exception.DirectSchedulingException;

@Repository(value="clinicByProviderDao")
public class ClinicByProviderDaoJSONImpl implements ClinicByProviderDao {

	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(ClinicByProviderDaoJSONImpl.class);

	@Override
	public List<ClinicProvider> getClinicNameByProvider() {
		String jsonFile = "com/agilex/healthcare/directscheduling/dao/clinicByProvider.json";
		final ObjectMapper mapper = new ObjectMapper();
		InputStream clinicByProviderJsonFile = null;
		try {
			clinicByProviderJsonFile = ClinicByProviderDaoJSONImpl.class.getClassLoader().getResourceAsStream(jsonFile);
			final List<ClinicProvider> clinicProviderList = mapper.readValue(clinicByProviderJsonFile,
					TypeFactory.defaultInstance().constructCollectionType(List.class,ClinicProvider.class));
			return(clinicProviderList);
		} catch (JsonParseException e) {
			throw new DirectSchedulingException("Error parsing JSON file");
		} catch (JsonMappingException e) {
			throw new DirectSchedulingException("Error mapping JSON fields");
		} catch (IOException e) {
			throw new DirectSchedulingException("An Error occurred while reading the JSON file");
		}
		finally{
			if(clinicByProviderJsonFile != null){
				try {
					clinicByProviderJsonFile.close();
				} catch (IOException e) {
					throw new DirectSchedulingException("An Error occurred while closing the JSON file");
				}
			}
		}
	}
}
